// bubbleSort.java
// demonstruje sortowanie bbelkowe
// uruchomienie programu: C>java BubbleSortApp
////////////////////////////////////////////////////////////////
class ArrayBub
   {
   private long[] a;                 // referencja do tablicy
   private int nElems;               // licznik elementw
//--------------------------------------------------------------
   public ArrayBub(int max)          // konstruktor
      {
      a = new long[max];                 // tworzymy tablic
      nElems = 0;                        // na razie brak elementw
      }
//--------------------------------------------------------------
   public void insert(long value)    // wstawienie elementu do tablicy
      {
      a[nElems] = value;             // wstawiamy element
      nElems++;                      // zwikszamy licznik elementw
      }
//--------------------------------------------------------------
   public void display()             // wypisuje zawarto tablicy
      {
      for(int j=0; j<nElems; j++)       // dla kadego elementu...
         System.out.print(a[j] + " ");  // ...wypisujemy jego warto
      System.out.println("");
      }
//--------------------------------------------------------------
   public void bubbleSort()
      {
      int out, in;

      for(out=nElems-1; out>1; out--)   // ptla zewntrzna (malejca)
         for(in=0; in<out; in++)        // ptla wewntrzna (rosnca)
            if( a[in] > a[in+1] )       // za kolejno?
               swap(in, in+1);          // no to zamiana
      }  // koniec bubbleSort()
//--------------------------------------------------------------
   private void swap(int one, int two)
      {
      long temp = a[one];
      a[one] = a[two];
      a[two] = temp;
      }
//--------------------------------------------------------------
   }  // koniec klasy ArrayBub
////////////////////////////////////////////////////////////////
class BubbleSortApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;            // rozmiar tablicy
      ArrayBub arr;                 // referencja do tablicy
      arr = new ArrayBub(maxSize);  // tworzymy tablic

      arr.insert(77);               // wstawiamy 10 elementw
      arr.insert(99);
      arr.insert(44);
      arr.insert(55);
      arr.insert(22);
      arr.insert(88);
      arr.insert(11);
      arr.insert(00);
      arr.insert(66);
      arr.insert(33);

      arr.display();                // wypisujemy je

      arr.bubbleSort();             // sortujemy bbelkowo

      arr.display();                // i znw wypisujemy
      }  // koniec main()
   }  // koniec klasy BubbleSortApp
////////////////////////////////////////////////////////////////
